/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!*************************************************************!*\
  !*** ./resources/js/design_1/parts/range_slider_helpers.js ***!
  \*************************************************************/
(function ($) {
  "use strict";

  window.handleDoubleRange = function ($el, item, callback) {
    if ($el && $el.length) {
      var _$el$attr;
      var minLimit = $el.attr('data-minLimit');
      var maxLimit = $el.attr('data-maxLimit');
      var step = (_$el$attr = $el.attr('data-step')) !== null && _$el$attr !== void 0 ? _$el$attr : 1;
      var minTimeEl = $el.find('input[name="min_' + item + '"]');
      var maxTimeEl = $el.find('input[name="max_' + item + '"]');
      var minValue = minTimeEl.val();
      var maxValue = maxTimeEl.val();
      if (!minValue) {
        minValue = Number(minLimit);
      }
      if (!maxValue) {
        maxValue = Number(maxLimit);
      }
      var range = $el.wRunner({
        type: 'range',
        limits: {
          minLimit: minLimit,
          maxLimit: maxLimit
        },
        rangeValue: {
          minValue: minValue,
          maxValue: maxValue
        },
        step: Number(step)
      });
      callback(range, minTimeEl, maxTimeEl);
    }
  };
  var triggerTimeout;
  window.handleTriggerInputForAjax = function ($el) {
    if (triggerTimeout) {
      clearTimeout(triggerTimeout);
    }
    triggerTimeout = setTimeout(function () {
      $el.trigger('change');
    }, 500);
  };
})(jQuery);
/******/ })()
;